package conversions;
import java.awt.*;

public class LengthQuantity extends ObservableQuantity {
	
	private double value;
	
	private int type=0;

	private String units = "inches";

	private boolean metric = false;
	private String name = "";
	
	public boolean isMetric() {
		return metric;
	}
	
	public LengthQuantity(
		double _value, 
		String _name,
		int _type) {
		name = _name;
		value = _value;
		type = _type;
	}
	
	public double getValue() {
		return value;
	}
	
	
	public void setValue(double d) {
		convertToEnglish();
		if (value == d) return;
		value = d;
		setChanged();
		
	}
	public int getType() {
		return type;
	}
	
	public String getUnits() {
		return units;
	}
	public void convertToMetric() {
		if (metric == true) return;
		setChanged();
		metric = true;
		units = "mm";
		value =
			value * 25.4;
	}
	public String toString() {
		return name+"=" + value + " "+units;
	}
	public void convertToEnglish() {
		if (metric == false) return;
		setChanged();
		metric = false;
		units = "inches";
		value =
			value /25.4;
	}
	
	
	public  void test() {

		System.out.println(this );
		convertToEnglish();
		System.out.println(this );
		convertToMetric();
		System.out.println(this);
	}		
 
		
}